using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using Microsoft.ContentManagement.WebControls;

namespace ContosoNet.Content_Templates
{
	/// <summary>
	/// Summary description for BaseTemplate.
	/// </summary>
	public class JobPosting : System.Web.UI.Page
	{
		protected Microsoft.ContentManagement.WebControls.RobotMetaTag RobotMetaTag1;
		protected ContosoNetControls.CustomProperties CustomProperties1;
		protected System.Web.UI.WebControls.Label QuoteLabel;
		protected System.Web.UI.WebControls.Label AttributionLabel;
		protected System.Web.UI.WebControls.Label EqualOpportunityLabel;
		protected Microsoft.ContentManagement.WebControls.HtmlPlaceholderControl SummaryPlaceholderControl;
		protected Telerik.WebControls.RadEditorPlaceHolderControl JobDescriptionPlaceholderControl;
		protected Telerik.WebControls.RadEditorPlaceHolderControl InternalPostingPlaceholderControl;
		protected Telerik.WebControls.RadEditorPlaceHolderControl HROnlyPlaceholderControl;
		protected System.Web.UI.WebControls.Label InternalPostingLabel;
		protected System.Web.UI.WebControls.Label HROnlyLabel;
	
		protected LocalizationManager localizationManager;

		private void Page_Load(object sender, System.EventArgs e)
		{
			localizationManager = new LocalizationManager ();
			QuoteLabel.Text = localizationManager.GetString ("jobPostingQuote");
			AttributionLabel.Text = localizationManager.GetString ("jobPostingAttribution");
			EqualOpportunityLabel.Text = localizationManager.GetString ("jobPostingEqualOpportunity");

			if (WebAuthorContext.Current.Mode == WebAuthorContextMode.PresentationPublished)
			{
				// Hide internal placeholders for published content
				InternalPostingLabel.Visible = false;
				InternalPostingPlaceholderControl.Visible = false;
				HROnlyLabel.Visible = false;
				HROnlyPlaceholderControl.Visible = false;
			}
			else
			{
				// Show internal placeholders for published content
				InternalPostingLabel.Visible = true;
				InternalPostingPlaceholderControl.Visible = true;
				HROnlyLabel.Visible = true;
				HROnlyPlaceholderControl.Visible = true;
			}

		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
